@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.BlobStorageTokenStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the storage of the tokens if blob storage is used.
 * @property sasUrlSettingName The name of the app setting containing the SAS URL of the blob storage containing the tokens.
 */
public data class BlobStorageTokenStoreArgs(
    public val sasUrlSettingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.BlobStorageTokenStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.BlobStorageTokenStoreArgs =
        com.pulumi.azurenative.web.inputs.BlobStorageTokenStoreArgs.builder()
            .sasUrlSettingName(sasUrlSettingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobStorageTokenStoreArgs].
 */
@PulumiTagMarker
public class BlobStorageTokenStoreArgsBuilder internal constructor() {
    private var sasUrlSettingName: Output<String>? = null

    /**
     * @param value The name of the app setting containing the SAS URL of the blob storage containing the tokens.
     */
    @JvmName("bmobxaqgsjtrgvfk")
    public suspend fun sasUrlSettingName(`value`: Output<String>) {
        this.sasUrlSettingName = value
    }

    /**
     * @param value The name of the app setting containing the SAS URL of the blob storage containing the tokens.
     */
    @JvmName("rhcbqiilrtsetcnq")
    public suspend fun sasUrlSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasUrlSettingName = mapped
    }

    internal fun build(): BlobStorageTokenStoreArgs = BlobStorageTokenStoreArgs(
        sasUrlSettingName = sasUrlSettingName,
    )
}
