@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConnStringValueTypePairArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.ConnectionStringType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Database connection string value to type pair.
 * @property type Type of database.
 * @property value Value of pair.
 */
public data class ConnStringValueTypePairArgs(
    public val type: Output<ConnectionStringType>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConnStringValueTypePairArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConnStringValueTypePairArgs =
        com.pulumi.azurenative.web.inputs.ConnStringValueTypePairArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnStringValueTypePairArgs].
 */
@PulumiTagMarker
public class ConnStringValueTypePairArgsBuilder internal constructor() {
    private var type: Output<ConnectionStringType>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Type of database.
     */
    @JvmName("hxgtsdugvotjeddw")
    public suspend fun type(`value`: Output<ConnectionStringType>) {
        this.type = value
    }

    /**
     * @param value Value of pair.
     */
    @JvmName("usjpmghrnfswtuuj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Type of database.
     */
    @JvmName("isbfcgdwttpdyxlu")
    public suspend fun type(`value`: ConnectionStringType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of pair.
     */
    @JvmName("ixsrcxrmyapdjqkg")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ConnStringValueTypePairArgs = ConnStringValueTypePairArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
