@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConnectionParameterArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.ConnectionParameterType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Connection provider parameters
 * @property oAuthSettings OAuth settings for the connection provider
 * @property type Type of the parameter
 */
public data class ConnectionParameterArgs(
    public val oAuthSettings: Output<ApiOAuthSettingsArgs>? = null,
    public val type: Output<ConnectionParameterType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConnectionParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConnectionParameterArgs =
        com.pulumi.azurenative.web.inputs.ConnectionParameterArgs.builder()
            .oAuthSettings(oAuthSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectionParameterArgs].
 */
@PulumiTagMarker
public class ConnectionParameterArgsBuilder internal constructor() {
    private var oAuthSettings: Output<ApiOAuthSettingsArgs>? = null

    private var type: Output<ConnectionParameterType>? = null

    /**
     * @param value OAuth settings for the connection provider
     */
    @JvmName("novhuwaoforqghwr")
    public suspend fun oAuthSettings(`value`: Output<ApiOAuthSettingsArgs>) {
        this.oAuthSettings = value
    }

    /**
     * @param value Type of the parameter
     */
    @JvmName("jcjxgncwxxcuavsa")
    public suspend fun type(`value`: Output<ConnectionParameterType>) {
        this.type = value
    }

    /**
     * @param value OAuth settings for the connection provider
     */
    @JvmName("ersndtyhkmyxymwb")
    public suspend fun oAuthSettings(`value`: ApiOAuthSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oAuthSettings = mapped
    }

    /**
     * @param argument OAuth settings for the connection provider
     */
    @JvmName("apfpgnlbvsymixst")
    public suspend fun oAuthSettings(argument: suspend ApiOAuthSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ApiOAuthSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oAuthSettings = mapped
    }

    /**
     * @param value Type of the parameter
     */
    @JvmName("wlniocvmqjibhlsr")
    public suspend fun type(`value`: ConnectionParameterType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConnectionParameterArgs = ConnectionParameterArgs(
        oAuthSettings = oAuthSettings,
        type = type,
    )
}
