@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConsentLinkParameterDefinition.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Consent link definition
 * @property objectId AAD OID (user or group) if the principal type is ActiveDirectory. MSA PUID if the principal type is MicrosoftAccount
 * @property parameterName Name of the parameter in the connection provider's OAuth settings
 * @property redirectUrl Name of the parameter in the connection provider's OAuth settings
 * @property tenantId The tenant id
 */
public data class ConsentLinkParameterDefinition(
    public val objectId: String? = null,
    public val parameterName: String? = null,
    public val redirectUrl: String? = null,
    public val tenantId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConsentLinkParameterDefinition> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConsentLinkParameterDefinition =
        com.pulumi.azurenative.web.inputs.ConsentLinkParameterDefinition.builder()
            .objectId(objectId?.let({ args0 -> args0 }))
            .parameterName(parameterName?.let({ args0 -> args0 }))
            .redirectUrl(redirectUrl?.let({ args0 -> args0 }))
            .tenantId(tenantId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ConsentLinkParameterDefinition].
 */
@PulumiTagMarker
public class ConsentLinkParameterDefinitionBuilder internal constructor() {
    private var objectId: String? = null

    private var parameterName: String? = null

    private var redirectUrl: String? = null

    private var tenantId: String? = null

    /**
     * @param value AAD OID (user or group) if the principal type is ActiveDirectory. MSA PUID if the principal type is MicrosoftAccount
     */
    @JvmName("ehnssrqbksrxpkeu")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.objectId = mapped
    }

    /**
     * @param value Name of the parameter in the connection provider's OAuth settings
     */
    @JvmName("xeenwvlyeipcgomw")
    public suspend fun parameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameterName = mapped
    }

    /**
     * @param value Name of the parameter in the connection provider's OAuth settings
     */
    @JvmName("ditmssadbrjhvqxi")
    public suspend fun redirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.redirectUrl = mapped
    }

    /**
     * @param value The tenant id
     */
    @JvmName("vixryncoyhcumxrg")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tenantId = mapped
    }

    internal fun build(): ConsentLinkParameterDefinition = ConsentLinkParameterDefinition(
        objectId = objectId,
        parameterName = parameterName,
        redirectUrl = redirectUrl,
        tenantId = tenantId,
    )
}
