@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ExtendedLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Extended Location.
 * @property name Name of extended location.
 */
public data class ExtendedLocationArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ExtendedLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ExtendedLocationArgs =
        com.pulumi.azurenative.web.inputs.ExtendedLocationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtendedLocationArgs].
 */
@PulumiTagMarker
public class ExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of extended location.
     */
    @JvmName("thlxvfvesttjsvgd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of extended location.
     */
    @JvmName("mkdximawyciwkxqd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ExtendedLocationArgs = ExtendedLocationArgs(
        name = name,
    )
}
