@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property linkedBackendName Name of the linked backend that should be retrieved
 * @property name Name of the static site
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetStaticSiteLinkedBackendPlainArgs(
    public val linkedBackendName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendPlainArgs =
        com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendPlainArgs.builder()
            .linkedBackendName(linkedBackendName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticSiteLinkedBackendPlainArgs].
 */
@PulumiTagMarker
public class GetStaticSiteLinkedBackendPlainArgsBuilder internal constructor() {
    private var linkedBackendName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the linked backend that should be retrieved
     */
    @JvmName("wgdbdpxhueicdfxv")
    public suspend fun linkedBackendName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkedBackendName = mapped
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("tsplwrlkxnyrcaqg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("trevfqnmcgnrtbvo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStaticSiteLinkedBackendPlainArgs = GetStaticSiteLinkedBackendPlainArgs(
        linkedBackendName = linkedBackendName ?: throw PulumiNullFieldException("linkedBackendName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
