@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppFunctionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionName Function name.
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppFunctionPlainArgs(
    public val functionName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppFunctionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppFunctionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppFunctionPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppFunctionPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppFunctionPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Function name.
     */
    @JvmName("nkcelgabexhfbohn")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("wxmavkucmaxdqbov")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("gkijbvvfsxtsqdyh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppFunctionPlainArgs = GetWebAppFunctionPlainArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
