@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the site.
 * @property privateEndpointConnectionName Name of the private endpoint connection.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppPrivateEndpointConnectionPlainArgs(
    public val name: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the site.
     */
    @JvmName("yofxnuqdfaybnqkp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the private endpoint connection.
     */
    @JvmName("egdvqbfnrbsytfbf")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ilxbkeqvcruywcqu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppPrivateEndpointConnectionPlainArgs =
        GetWebAppPrivateEndpointConnectionPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
