@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Site Container Name
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppSiteContainerPlainArgs(
    public val containerName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerPlainArgs.builder()
            .containerName(containerName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppSiteContainerPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppSiteContainerPlainArgsBuilder internal constructor() {
    private var containerName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Site Container Name
     */
    @JvmName("kgpyjfpsfxxglgvd")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("qvbmfvdpmlukcodb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bphwbhqikoyjkkrx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppSiteContainerPlainArgs = GetWebAppSiteContainerPlainArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
