@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Site Container Name
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will get the Site Container for the production slot.
 */
public data class GetWebAppSiteContainerSlotPlainArgs(
    public val containerName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppSiteContainerSlotPlainArgs.builder()
            .containerName(containerName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppSiteContainerSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppSiteContainerSlotPlainArgsBuilder internal constructor() {
    private var containerName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Site Container Name
     */
    @JvmName("qqqylfjqxojvydqj")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("ualufgrlswphknmm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("hhmlftuybtkdwjwb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will get the Site Container for the production slot.
     */
    @JvmName("uygfscknbenglccu")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppSiteContainerSlotPlainArgs = GetWebAppSiteContainerSlotPlainArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        slot = slot ?: throw PulumiNullFieldException("slot"),
    )
}
