@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will get the named virtual network for the production slot.
 * @property vnetName Name of the virtual network.
 */
public data class GetWebAppVnetConnectionSlotPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
    public val vnetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppVnetConnectionSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 }))
            .vnetName(vnetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppVnetConnectionSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppVnetConnectionSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    private var vnetName: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("areciirpdmddtdgl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("xqvpqtklbhpkkqwl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will get the named virtual network for the production slot.
     */
    @JvmName("aaouqdrcyejivgwj")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    /**
     * @param value Name of the virtual network.
     */
    @JvmName("pewdlcskqdlwymmc")
    public suspend fun vnetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vnetName = mapped
    }

    internal fun build(): GetWebAppVnetConnectionSlotPlainArgs = GetWebAppVnetConnectionSlotPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        slot = slot ?: throw PulumiNullFieldException("slot"),
        vnetName = vnetName ?: throw PulumiNullFieldException("vnetName"),
    )
}
