@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GitHubActionCodeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The GitHub action code configuration.
 * @property runtimeStack Runtime stack is used to determine the workflow file content for code base apps.
 * @property runtimeVersion Runtime version is used to determine what build version to set in the workflow file.
 */
public data class GitHubActionCodeConfigurationArgs(
    public val runtimeStack: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GitHubActionCodeConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GitHubActionCodeConfigurationArgs =
        com.pulumi.azurenative.web.inputs.GitHubActionCodeConfigurationArgs.builder()
            .runtimeStack(runtimeStack?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubActionCodeConfigurationArgs].
 */
@PulumiTagMarker
public class GitHubActionCodeConfigurationArgsBuilder internal constructor() {
    private var runtimeStack: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    /**
     * @param value Runtime stack is used to determine the workflow file content for code base apps.
     */
    @JvmName("hkkcyostsyfwqkmt")
    public suspend fun runtimeStack(`value`: Output<String>) {
        this.runtimeStack = value
    }

    /**
     * @param value Runtime version is used to determine what build version to set in the workflow file.
     */
    @JvmName("xqapgqietmnusmjk")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Runtime stack is used to determine the workflow file content for code base apps.
     */
    @JvmName("vcsctcsdrqfsihqp")
    public suspend fun runtimeStack(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeStack = mapped
    }

    /**
     * @param value Runtime version is used to determine what build version to set in the workflow file.
     */
    @JvmName("vxnoapoxbcjfmcef")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    internal fun build(): GitHubActionCodeConfigurationArgs = GitHubActionCodeConfigurationArgs(
        runtimeStack = runtimeStack,
        runtimeVersion = runtimeVersion,
    )
}
