@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GitHubActionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The GitHub action configuration.
 * @property codeConfiguration GitHub Action code configuration.
 * @property containerConfiguration GitHub Action container configuration.
 * @property generateWorkflowFile Workflow option to determine whether the workflow file should be generated and written to the repository.
 * @property isLinux This will help determine the workflow configuration to select.
 */
public data class GitHubActionConfigurationArgs(
    public val codeConfiguration: Output<GitHubActionCodeConfigurationArgs>? = null,
    public val containerConfiguration: Output<GitHubActionContainerConfigurationArgs>? = null,
    public val generateWorkflowFile: Output<Boolean>? = null,
    public val isLinux: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GitHubActionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GitHubActionConfigurationArgs =
        com.pulumi.azurenative.web.inputs.GitHubActionConfigurationArgs.builder()
            .codeConfiguration(codeConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerConfiguration(
                containerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .generateWorkflowFile(generateWorkflowFile?.applyValue({ args0 -> args0 }))
            .isLinux(isLinux?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubActionConfigurationArgs].
 */
@PulumiTagMarker
public class GitHubActionConfigurationArgsBuilder internal constructor() {
    private var codeConfiguration: Output<GitHubActionCodeConfigurationArgs>? = null

    private var containerConfiguration: Output<GitHubActionContainerConfigurationArgs>? = null

    private var generateWorkflowFile: Output<Boolean>? = null

    private var isLinux: Output<Boolean>? = null

    /**
     * @param value GitHub Action code configuration.
     */
    @JvmName("wohbglvbcfewoawe")
    public suspend fun codeConfiguration(`value`: Output<GitHubActionCodeConfigurationArgs>) {
        this.codeConfiguration = value
    }

    /**
     * @param value GitHub Action container configuration.
     */
    @JvmName("qlopipesasyymwqm")
    public suspend fun containerConfiguration(`value`: Output<GitHubActionContainerConfigurationArgs>) {
        this.containerConfiguration = value
    }

    /**
     * @param value Workflow option to determine whether the workflow file should be generated and written to the repository.
     */
    @JvmName("coxqdhllqnnnmlux")
    public suspend fun generateWorkflowFile(`value`: Output<Boolean>) {
        this.generateWorkflowFile = value
    }

    /**
     * @param value This will help determine the workflow configuration to select.
     */
    @JvmName("ramkqlkgsahryrsh")
    public suspend fun isLinux(`value`: Output<Boolean>) {
        this.isLinux = value
    }

    /**
     * @param value GitHub Action code configuration.
     */
    @JvmName("liokbdanjpwahxgy")
    public suspend fun codeConfiguration(`value`: GitHubActionCodeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeConfiguration = mapped
    }

    /**
     * @param argument GitHub Action code configuration.
     */
    @JvmName("xyvddtordixqbxcn")
    public suspend fun codeConfiguration(argument: suspend GitHubActionCodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubActionCodeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.codeConfiguration = mapped
    }

    /**
     * @param value GitHub Action container configuration.
     */
    @JvmName("vhteppnqwqsxaiya")
    public suspend fun containerConfiguration(`value`: GitHubActionContainerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerConfiguration = mapped
    }

    /**
     * @param argument GitHub Action container configuration.
     */
    @JvmName("kqbvgjytvmtrcdjl")
    public suspend fun containerConfiguration(argument: suspend GitHubActionContainerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubActionContainerConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.containerConfiguration = mapped
    }

    /**
     * @param value Workflow option to determine whether the workflow file should be generated and written to the repository.
     */
    @JvmName("fvialsiqwkgcysnq")
    public suspend fun generateWorkflowFile(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generateWorkflowFile = mapped
    }

    /**
     * @param value This will help determine the workflow configuration to select.
     */
    @JvmName("wlxfbyrhjepxcggb")
    public suspend fun isLinux(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLinux = mapped
    }

    internal fun build(): GitHubActionConfigurationArgs = GitHubActionConfigurationArgs(
        codeConfiguration = codeConfiguration,
        containerConfiguration = containerConfiguration,
        generateWorkflowFile = generateWorkflowFile,
        isLinux = isLinux,
    )
}
