@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GoogleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Google provider.
 * @property enabled <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the app registration for the Google provider.
 * @property validation The configuration settings of the Azure Active Directory token validation flow.
 */
public data class GoogleArgs(
    public val enabled: Output<Boolean>? = null,
    public val login: Output<LoginScopesArgs>? = null,
    public val registration: Output<ClientRegistrationArgs>? = null,
    public val validation: Output<AllowedAudiencesValidationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GoogleArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GoogleArgs =
        com.pulumi.azurenative.web.inputs.GoogleArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validation(validation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GoogleArgs].
 */
@PulumiTagMarker
public class GoogleArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var login: Output<LoginScopesArgs>? = null

    private var registration: Output<ClientRegistrationArgs>? = null

    private var validation: Output<AllowedAudiencesValidationArgs>? = null

    /**
     * @param value <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("kjsllwapshgiapxv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("ctbuteqccyrfexbe")
    public suspend fun login(`value`: Output<LoginScopesArgs>) {
        this.login = value
    }

    /**
     * @param value The configuration settings of the app registration for the Google provider.
     */
    @JvmName("ijbfxcyitrsdbctb")
    public suspend fun registration(`value`: Output<ClientRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value The configuration settings of the Azure Active Directory token validation flow.
     */
    @JvmName("ekxcylbreyxavxsj")
    public suspend fun validation(`value`: Output<AllowedAudiencesValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("eiuwqalilyxorrjm")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("evqyaltlwqoknuxd")
    public suspend fun login(`value`: LoginScopesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the login flow.
     */
    @JvmName("taxwkgkarutgyaci")
    public suspend fun login(argument: suspend LoginScopesArgsBuilder.() -> Unit) {
        val toBeMapped = LoginScopesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value The configuration settings of the app registration for the Google provider.
     */
    @JvmName("xfhvhhsyhjcbrxxy")
    public suspend fun registration(`value`: ClientRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the app registration for the Google provider.
     */
    @JvmName("qjxinvhvdudovfoc")
    public suspend fun registration(argument: suspend ClientRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = ClientRegistrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    /**
     * @param value The configuration settings of the Azure Active Directory token validation flow.
     */
    @JvmName("jvdkhokyylbcqhoi")
    public suspend fun validation(`value`: AllowedAudiencesValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Active Directory token validation flow.
     */
    @JvmName("eijiqwgjgdsurfpb")
    public suspend fun validation(argument: suspend AllowedAudiencesValidationArgsBuilder.() -> Unit) {
        val toBeMapped = AllowedAudiencesValidationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): GoogleArgs = GoogleArgs(
        enabled = enabled,
        login = login,
        registration = registration,
        validation = validation,
    )
}
