@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.HttpLogsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Http logs configuration.
 * @property azureBlobStorage Http logs to azure blob storage configuration.
 * @property fileSystem Http logs to file system configuration.
 */
public data class HttpLogsConfigArgs(
    public val azureBlobStorage: Output<AzureBlobStorageHttpLogsConfigArgs>? = null,
    public val fileSystem: Output<FileSystemHttpLogsConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.HttpLogsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.HttpLogsConfigArgs =
        com.pulumi.azurenative.web.inputs.HttpLogsConfigArgs.builder()
            .azureBlobStorage(azureBlobStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HttpLogsConfigArgs].
 */
@PulumiTagMarker
public class HttpLogsConfigArgsBuilder internal constructor() {
    private var azureBlobStorage: Output<AzureBlobStorageHttpLogsConfigArgs>? = null

    private var fileSystem: Output<FileSystemHttpLogsConfigArgs>? = null

    /**
     * @param value Http logs to azure blob storage configuration.
     */
    @JvmName("qmyxekostodcmypj")
    public suspend fun azureBlobStorage(`value`: Output<AzureBlobStorageHttpLogsConfigArgs>) {
        this.azureBlobStorage = value
    }

    /**
     * @param value Http logs to file system configuration.
     */
    @JvmName("balalciplnrhwbcr")
    public suspend fun fileSystem(`value`: Output<FileSystemHttpLogsConfigArgs>) {
        this.fileSystem = value
    }

    /**
     * @param value Http logs to azure blob storage configuration.
     */
    @JvmName("gojkylwwubffhnrm")
    public suspend fun azureBlobStorage(`value`: AzureBlobStorageHttpLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBlobStorage = mapped
    }

    /**
     * @param argument Http logs to azure blob storage configuration.
     */
    @JvmName("nymhoabstdvlvhfu")
    public suspend fun azureBlobStorage(argument: suspend AzureBlobStorageHttpLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AzureBlobStorageHttpLogsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureBlobStorage = mapped
    }

    /**
     * @param value Http logs to file system configuration.
     */
    @JvmName("ktcibxuvwvrealpw")
    public suspend fun fileSystem(`value`: FileSystemHttpLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param argument Http logs to file system configuration.
     */
    @JvmName("xasugqumuupvgmkg")
    public suspend fun fileSystem(argument: suspend FileSystemHttpLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FileSystemHttpLogsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fileSystem = mapped
    }

    internal fun build(): HttpLogsConfigArgs = HttpLogsConfigArgs(
        azureBlobStorage = azureBlobStorage,
        fileSystem = fileSystem,
    )
}
