@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.HttpSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.
 * @property forwardProxy The configuration settings of a forward proxy used to make the requests.
 * @property requireHttps <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
 * @property routes The configuration settings of the paths HTTP requests.
 */
public data class HttpSettingsArgs(
    public val forwardProxy: Output<ForwardProxyArgs>? = null,
    public val requireHttps: Output<Boolean>? = null,
    public val routes: Output<HttpSettingsRoutesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.HttpSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.HttpSettingsArgs =
        com.pulumi.azurenative.web.inputs.HttpSettingsArgs.builder()
            .forwardProxy(forwardProxy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requireHttps(requireHttps?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HttpSettingsArgs].
 */
@PulumiTagMarker
public class HttpSettingsArgsBuilder internal constructor() {
    private var forwardProxy: Output<ForwardProxyArgs>? = null

    private var requireHttps: Output<Boolean>? = null

    private var routes: Output<HttpSettingsRoutesArgs>? = null

    /**
     * @param value The configuration settings of a forward proxy used to make the requests.
     */
    @JvmName("dwyureuapaaybcim")
    public suspend fun forwardProxy(`value`: Output<ForwardProxyArgs>) {
        this.forwardProxy = value
    }

    /**
     * @param value <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
     */
    @JvmName("vimqmwdxcsfjsaeg")
    public suspend fun requireHttps(`value`: Output<Boolean>) {
        this.requireHttps = value
    }

    /**
     * @param value The configuration settings of the paths HTTP requests.
     */
    @JvmName("xhoxolulhwlcqmme")
    public suspend fun routes(`value`: Output<HttpSettingsRoutesArgs>) {
        this.routes = value
    }

    /**
     * @param value The configuration settings of a forward proxy used to make the requests.
     */
    @JvmName("espuqqyjsamwugfu")
    public suspend fun forwardProxy(`value`: ForwardProxyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardProxy = mapped
    }

    /**
     * @param argument The configuration settings of a forward proxy used to make the requests.
     */
    @JvmName("vlkthtydpurxhlmx")
    public suspend fun forwardProxy(argument: suspend ForwardProxyArgsBuilder.() -> Unit) {
        val toBeMapped = ForwardProxyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.forwardProxy = mapped
    }

    /**
     * @param value <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
     */
    @JvmName("dlluwgaygnhsbrlm")
    public suspend fun requireHttps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireHttps = mapped
    }

    /**
     * @param value The configuration settings of the paths HTTP requests.
     */
    @JvmName("hevnyfcxmowsadjv")
    public suspend fun routes(`value`: HttpSettingsRoutesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument The configuration settings of the paths HTTP requests.
     */
    @JvmName("hjubmflveyysotxq")
    public suspend fun routes(argument: suspend HttpSettingsRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = HttpSettingsRoutesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    internal fun build(): HttpSettingsArgs = HttpSettingsArgs(
        forwardProxy = forwardProxy,
        requireHttps = requireHttps,
        routes = routes,
    )
}
