@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.HttpSettingsRoutesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the paths HTTP requests.
 * @property apiPrefix The prefix that should precede all the authentication/authorization paths.
 */
public data class HttpSettingsRoutesArgs(
    public val apiPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.HttpSettingsRoutesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.HttpSettingsRoutesArgs =
        com.pulumi.azurenative.web.inputs.HttpSettingsRoutesArgs.builder()
            .apiPrefix(apiPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpSettingsRoutesArgs].
 */
@PulumiTagMarker
public class HttpSettingsRoutesArgsBuilder internal constructor() {
    private var apiPrefix: Output<String>? = null

    /**
     * @param value The prefix that should precede all the authentication/authorization paths.
     */
    @JvmName("xamiofieqynviseo")
    public suspend fun apiPrefix(`value`: Output<String>) {
        this.apiPrefix = value
    }

    /**
     * @param value The prefix that should precede all the authentication/authorization paths.
     */
    @JvmName("ncigsornydybpatr")
    public suspend fun apiPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiPrefix = mapped
    }

    internal fun build(): HttpSettingsRoutesArgs = HttpSettingsRoutesArgs(
        apiPrefix = apiPrefix,
    )
}
