@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.IngressArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.IngressTransportMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App Ingress configuration.
 * @property allowInsecure Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
 * @property external Bool indicating if app exposes an external http endpoint
 * @property targetPort Target Port in containers for traffic from ingress
 * @property traffic
 * @property transport Ingress transport protocol
 */
public data class IngressArgs(
    public val allowInsecure: Output<Boolean>? = null,
    public val `external`: Output<Boolean>? = null,
    public val targetPort: Output<Int>? = null,
    public val traffic: Output<List<TrafficWeightArgs>>? = null,
    public val transport: Output<Either<String, IngressTransportMethod>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.IngressArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.IngressArgs =
        com.pulumi.azurenative.web.inputs.IngressArgs.builder()
            .allowInsecure(allowInsecure?.applyValue({ args0 -> args0 }))
            .`external`(`external`?.applyValue({ args0 -> args0 }))
            .targetPort(targetPort?.applyValue({ args0 -> args0 }))
            .traffic(
                traffic?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .transport(
                transport?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IngressArgs].
 */
@PulumiTagMarker
public class IngressArgsBuilder internal constructor() {
    private var allowInsecure: Output<Boolean>? = null

    private var `external`: Output<Boolean>? = null

    private var targetPort: Output<Int>? = null

    private var traffic: Output<List<TrafficWeightArgs>>? = null

    private var transport: Output<Either<String, IngressTransportMethod>>? = null

    /**
     * @param value Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
     */
    @JvmName("hhhxkfgubwqbwhha")
    public suspend fun allowInsecure(`value`: Output<Boolean>) {
        this.allowInsecure = value
    }

    /**
     * @param value Bool indicating if app exposes an external http endpoint
     */
    @JvmName("nabadscddlqpuxhc")
    public suspend fun `external`(`value`: Output<Boolean>) {
        this.`external` = value
    }

    /**
     * @param value Target Port in containers for traffic from ingress
     */
    @JvmName("hinobvqxwwqfyvwo")
    public suspend fun targetPort(`value`: Output<Int>) {
        this.targetPort = value
    }

    /**
     * @param value
     */
    @JvmName("humxtnljkqacejuw")
    public suspend fun traffic(`value`: Output<List<TrafficWeightArgs>>) {
        this.traffic = value
    }

    @JvmName("apwbiwbwhylkbnrs")
    public suspend fun traffic(vararg values: Output<TrafficWeightArgs>) {
        this.traffic = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ftmnnjmswgmwnncp")
    public suspend fun traffic(values: List<Output<TrafficWeightArgs>>) {
        this.traffic = Output.all(values)
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("gounvjoyomoeyxrd")
    public suspend fun transport(`value`: Output<Either<String, IngressTransportMethod>>) {
        this.transport = value
    }

    /**
     * @param value Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
     */
    @JvmName("snqqreiypshaelor")
    public suspend fun allowInsecure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInsecure = mapped
    }

    /**
     * @param value Bool indicating if app exposes an external http endpoint
     */
    @JvmName("gmpdljxpugtxkgdb")
    public suspend fun `external`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`external` = mapped
    }

    /**
     * @param value Target Port in containers for traffic from ingress
     */
    @JvmName("afqignonrchptjhu")
    public suspend fun targetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("iissrxqrrrkfaqjw")
    public suspend fun traffic(`value`: List<TrafficWeightArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traffic = mapped
    }

    /**
     * @param argument
     */
    @JvmName("anifbwydqarpyixs")
    public suspend fun traffic(argument: List<suspend TrafficWeightArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficWeightArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.traffic = mapped
    }

    /**
     * @param argument
     */
    @JvmName("angqhlysxvbsteth")
    public suspend fun traffic(vararg argument: suspend TrafficWeightArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrafficWeightArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.traffic = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wxieplixaoqktgim")
    public suspend fun traffic(argument: suspend TrafficWeightArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrafficWeightArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.traffic = mapped
    }

    /**
     * @param values
     */
    @JvmName("tlshwokbswcxkrby")
    public suspend fun traffic(vararg values: TrafficWeightArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.traffic = mapped
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("ychgfdolrevofrnr")
    public suspend fun transport(`value`: Either<String, IngressTransportMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("tqlrhdtovxcemeyr")
    public fun transport(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngressTransportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("npfqexsdgeirdmgv")
    public fun transport(`value`: IngressTransportMethod) {
        val toBeMapped = Either.ofRight<String, IngressTransportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    internal fun build(): IngressArgs = IngressArgs(
        allowInsecure = allowInsecure,
        `external` = `external`,
        targetPort = targetPort,
        traffic = traffic,
        transport = transport,
    )
}
