@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListConnectionKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The connection name.
 * @property id Resource Id
 * @property kind Kind of resource
 * @property location Resource Location
 * @property name Resource Name
 * @property resourceGroupName The resource group name.
 * @property tags Resource tags
 * @property type Resource type
 * @property validityTimeSpan time span for how long the keys will be valid
 */
public data class ListConnectionKeysPlainArgs(
    public val connectionName: String,
    public val id: String? = null,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val resourceGroupName: String,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val validityTimeSpan: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListConnectionKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListConnectionKeysPlainArgs =
        com.pulumi.azurenative.web.inputs.ListConnectionKeysPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .id(id?.let({ args0 -> args0 }))
            .kind(kind?.let({ args0 -> args0 }))
            .location(location?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 }))
            .validityTimeSpan(validityTimeSpan?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListConnectionKeysPlainArgs].
 */
@PulumiTagMarker
public class ListConnectionKeysPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var id: String? = null

    private var kind: String? = null

    private var location: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    private var validityTimeSpan: String? = null

    /**
     * @param value The connection name.
     */
    @JvmName("sieqvfasrhvgupmf")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value Resource Id
     */
    @JvmName("hhbikxvcxacqcrcb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Kind of resource
     */
    @JvmName("rigpbskukvvoygde")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kind = mapped
    }

    /**
     * @param value Resource Location
     */
    @JvmName("xsrbhtnnauhdfkoo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value Resource Name
     */
    @JvmName("jwbphhowosepkxik")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("wrwmsoycadsphjwc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("nyfmldnvkwkktdpv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("tdfbosjituphgucq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Resource type
     */
    @JvmName("elqgwjihwvubljjt")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value time span for how long the keys will be valid
     */
    @JvmName("lyyfcehtcxrymipw")
    public suspend fun validityTimeSpan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.validityTimeSpan = mapped
    }

    internal fun build(): ListConnectionKeysPlainArgs = ListConnectionKeysPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        id = id,
        kind = kind,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tags = tags,
        type = type,
        validityTimeSpan = validityTimeSpan,
    )
}
