@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListWebAppSiteBackupsSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will get backups of the production slot.
 */
public data class ListWebAppSiteBackupsSlotPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListWebAppSiteBackupsSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListWebAppSiteBackupsSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.ListWebAppSiteBackupsSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWebAppSiteBackupsSlotPlainArgs].
 */
@PulumiTagMarker
public class ListWebAppSiteBackupsSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("lsulhkoisyqhatjf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("axlgislxrbpkeegw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will get backups of the production slot.
     */
    @JvmName("vxunlrybuhwgstca")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): ListWebAppSiteBackupsSlotPlainArgs = ListWebAppSiteBackupsSlotPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        slot = slot ?: throw PulumiNullFieldException("slot"),
    )
}
