@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListWorkflowTriggerCallbackUrlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property triggerName The workflow trigger name.
 * @property workflowName The workflow name.
 */
public data class ListWorkflowTriggerCallbackUrlPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val triggerName: String,
    public val workflowName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListWorkflowTriggerCallbackUrlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListWorkflowTriggerCallbackUrlPlainArgs =
        com.pulumi.azurenative.web.inputs.ListWorkflowTriggerCallbackUrlPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkflowTriggerCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListWorkflowTriggerCallbackUrlPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var triggerName: String? = null

    private var workflowName: String? = null

    /**
     * @param value Site name.
     */
    @JvmName("lfuutbbooccnsqdh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vysjawykbjhrfnih")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow trigger name.
     */
    @JvmName("yunpalwnoyqdjkkj")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("qtgttlbgfoecorwv")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): ListWorkflowTriggerCallbackUrlPlainArgs =
        ListWorkflowTriggerCallbackUrlPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
            workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
        )
}
