@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.PrivateLinkConnectionStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The state of a private link connection
 * @property actionsRequired ActionsRequired for a private link connection
 * @property description Description of a private link connection
 * @property status Status of a private link connection
 */
public data class PrivateLinkConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.PrivateLinkConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.PrivateLinkConnectionStateArgs =
        com.pulumi.azurenative.web.inputs.PrivateLinkConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value ActionsRequired for a private link connection
     */
    @JvmName("whkdihpfolgofpsm")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value Description of a private link connection
     */
    @JvmName("blionojgaywyblvl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Status of a private link connection
     */
    @JvmName("kveenuwdjtawncvk")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value ActionsRequired for a private link connection
     */
    @JvmName("tpninbpplexhhaxb")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value Description of a private link connection
     */
    @JvmName("mcdleidtubihdaql")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Status of a private link connection
     */
    @JvmName("radxyotmlaligepc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkConnectionStateArgs = PrivateLinkConnectionStateArgs(
        actionsRequired = actionsRequired,
        description = description,
        status = status,
    )
}
