@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.QueueScaleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App container Azure Queue based scaling rule.
 * @property auth Authentication secrets for the queue scale rule.
 * @property queueLength Queue length.
 * @property queueName Queue name.
 */
public data class QueueScaleRuleArgs(
    public val auth: Output<List<ScaleRuleAuthArgs>>? = null,
    public val queueLength: Output<Int>? = null,
    public val queueName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.QueueScaleRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.QueueScaleRuleArgs =
        com.pulumi.azurenative.web.inputs.QueueScaleRuleArgs.builder()
            .auth(auth?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .queueLength(queueLength?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueScaleRuleArgs].
 */
@PulumiTagMarker
public class QueueScaleRuleArgsBuilder internal constructor() {
    private var auth: Output<List<ScaleRuleAuthArgs>>? = null

    private var queueLength: Output<Int>? = null

    private var queueName: Output<String>? = null

    /**
     * @param value Authentication secrets for the queue scale rule.
     */
    @JvmName("ljfdlfgldovowjka")
    public suspend fun auth(`value`: Output<List<ScaleRuleAuthArgs>>) {
        this.auth = value
    }

    @JvmName("rsrvfstuciknxtya")
    public suspend fun auth(vararg values: Output<ScaleRuleAuthArgs>) {
        this.auth = Output.all(values.asList())
    }

    /**
     * @param values Authentication secrets for the queue scale rule.
     */
    @JvmName("wtbdcyodsdsyhkjw")
    public suspend fun auth(values: List<Output<ScaleRuleAuthArgs>>) {
        this.auth = Output.all(values)
    }

    /**
     * @param value Queue length.
     */
    @JvmName("vifwwlqgelwqcdep")
    public suspend fun queueLength(`value`: Output<Int>) {
        this.queueLength = value
    }

    /**
     * @param value Queue name.
     */
    @JvmName("eqgerbbepiujqwrg")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value Authentication secrets for the queue scale rule.
     */
    @JvmName("akbkvnvnyqxluerj")
    public suspend fun auth(`value`: List<ScaleRuleAuthArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the queue scale rule.
     */
    @JvmName("pkjxmuloougiafnq")
    public suspend fun auth(argument: List<suspend ScaleRuleAuthArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the queue scale rule.
     */
    @JvmName("xgvxerlstkfmsdtv")
    public suspend fun auth(vararg argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the queue scale rule.
     */
    @JvmName("jasjymiqjofxgtey")
    public suspend fun auth(argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScaleRuleAuthArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param values Authentication secrets for the queue scale rule.
     */
    @JvmName("hmmksgkydhpwlojq")
    public suspend fun auth(vararg values: ScaleRuleAuthArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param value Queue length.
     */
    @JvmName("fljvplambfumbkan")
    public suspend fun queueLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueLength = mapped
    }

    /**
     * @param value Queue name.
     */
    @JvmName("oevmmywbbmnpihhg")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    internal fun build(): QueueScaleRuleArgs = QueueScaleRuleArgs(
        auth = auth,
        queueLength = queueLength,
        queueName = queueName,
    )
}
