@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.SiteLimitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Metric limits set on an app.
 * @property maxDiskSizeInMb Maximum allowed disk size usage in MB.
 * @property maxMemoryInMb Maximum allowed memory usage in MB.
 * @property maxPercentageCpu Maximum allowed CPU usage percentage.
 */
public data class SiteLimitsArgs(
    public val maxDiskSizeInMb: Output<Double>? = null,
    public val maxMemoryInMb: Output<Double>? = null,
    public val maxPercentageCpu: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.SiteLimitsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.SiteLimitsArgs =
        com.pulumi.azurenative.web.inputs.SiteLimitsArgs.builder()
            .maxDiskSizeInMb(maxDiskSizeInMb?.applyValue({ args0 -> args0 }))
            .maxMemoryInMb(maxMemoryInMb?.applyValue({ args0 -> args0 }))
            .maxPercentageCpu(maxPercentageCpu?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteLimitsArgs].
 */
@PulumiTagMarker
public class SiteLimitsArgsBuilder internal constructor() {
    private var maxDiskSizeInMb: Output<Double>? = null

    private var maxMemoryInMb: Output<Double>? = null

    private var maxPercentageCpu: Output<Double>? = null

    /**
     * @param value Maximum allowed disk size usage in MB.
     */
    @JvmName("navfgrgvmjfxlmid")
    public suspend fun maxDiskSizeInMb(`value`: Output<Double>) {
        this.maxDiskSizeInMb = value
    }

    /**
     * @param value Maximum allowed memory usage in MB.
     */
    @JvmName("jdxtggpwwwdwnsun")
    public suspend fun maxMemoryInMb(`value`: Output<Double>) {
        this.maxMemoryInMb = value
    }

    /**
     * @param value Maximum allowed CPU usage percentage.
     */
    @JvmName("jhlvpmqdpqpxghug")
    public suspend fun maxPercentageCpu(`value`: Output<Double>) {
        this.maxPercentageCpu = value
    }

    /**
     * @param value Maximum allowed disk size usage in MB.
     */
    @JvmName("olcneioajepmkjnn")
    public suspend fun maxDiskSizeInMb(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDiskSizeInMb = mapped
    }

    /**
     * @param value Maximum allowed memory usage in MB.
     */
    @JvmName("yvsyfclcrtawlbsp")
    public suspend fun maxMemoryInMb(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxMemoryInMb = mapped
    }

    /**
     * @param value Maximum allowed CPU usage percentage.
     */
    @JvmName("caqgrxskonytqhpr")
    public suspend fun maxPercentageCpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPercentageCpu = mapped
    }

    internal fun build(): SiteLimitsArgs = SiteLimitsArgs(
        maxDiskSizeInMb = maxDiskSizeInMb,
        maxMemoryInMb = maxMemoryInMb,
        maxPercentageCpu = maxPercentageCpu,
    )
}
