@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.SlowRequestsBasedTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trigger based on request execution time.
 * @property count Request Count.
 * @property path Request Path.
 * @property timeInterval Time interval.
 * @property timeTaken Time taken.
 */
public data class SlowRequestsBasedTriggerArgs(
    public val count: Output<Int>? = null,
    public val path: Output<String>? = null,
    public val timeInterval: Output<String>? = null,
    public val timeTaken: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.SlowRequestsBasedTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.SlowRequestsBasedTriggerArgs =
        com.pulumi.azurenative.web.inputs.SlowRequestsBasedTriggerArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .timeInterval(timeInterval?.applyValue({ args0 -> args0 }))
            .timeTaken(timeTaken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlowRequestsBasedTriggerArgs].
 */
@PulumiTagMarker
public class SlowRequestsBasedTriggerArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var path: Output<String>? = null

    private var timeInterval: Output<String>? = null

    private var timeTaken: Output<String>? = null

    /**
     * @param value Request Count.
     */
    @JvmName("jgppbkauqswixnml")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Request Path.
     */
    @JvmName("ruubbitaeyeaofbd")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Time interval.
     */
    @JvmName("twjhujkqeonlyomx")
    public suspend fun timeInterval(`value`: Output<String>) {
        this.timeInterval = value
    }

    /**
     * @param value Time taken.
     */
    @JvmName("qymwfokchxdjqoiv")
    public suspend fun timeTaken(`value`: Output<String>) {
        this.timeTaken = value
    }

    /**
     * @param value Request Count.
     */
    @JvmName("krtrcndudljcwxqw")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Request Path.
     */
    @JvmName("ltgpnybllyctssnf")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Time interval.
     */
    @JvmName("qxsmiiknicccsupr")
    public suspend fun timeInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInterval = mapped
    }

    /**
     * @param value Time taken.
     */
    @JvmName("efyknjrjbkfhoyjg")
    public suspend fun timeTaken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeTaken = mapped
    }

    internal fun build(): SlowRequestsBasedTriggerArgs = SlowRequestsBasedTriggerArgs(
        count = count,
        path = path,
        timeInterval = timeInterval,
        timeTaken = timeTaken,
    )
}
