@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.StatusCodesBasedTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trigger based on status code.
 * @property count Request Count.
 * @property path Request Path
 * @property status HTTP status code.
 * @property subStatus Request Sub Status.
 * @property timeInterval Time interval.
 * @property win32Status Win32 error code.
 */
public data class StatusCodesBasedTriggerArgs(
    public val count: Output<Int>? = null,
    public val path: Output<String>? = null,
    public val status: Output<Int>? = null,
    public val subStatus: Output<Int>? = null,
    public val timeInterval: Output<String>? = null,
    public val win32Status: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.StatusCodesBasedTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.StatusCodesBasedTriggerArgs =
        com.pulumi.azurenative.web.inputs.StatusCodesBasedTriggerArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .subStatus(subStatus?.applyValue({ args0 -> args0 }))
            .timeInterval(timeInterval?.applyValue({ args0 -> args0 }))
            .win32Status(win32Status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatusCodesBasedTriggerArgs].
 */
@PulumiTagMarker
public class StatusCodesBasedTriggerArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var path: Output<String>? = null

    private var status: Output<Int>? = null

    private var subStatus: Output<Int>? = null

    private var timeInterval: Output<String>? = null

    private var win32Status: Output<Int>? = null

    /**
     * @param value Request Count.
     */
    @JvmName("lbceifaivinbocgp")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Request Path
     */
    @JvmName("ysvfjcainnpcashp")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value HTTP status code.
     */
    @JvmName("hrcapxnprgeagnum")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value Request Sub Status.
     */
    @JvmName("mkgfsbwtgygsdatj")
    public suspend fun subStatus(`value`: Output<Int>) {
        this.subStatus = value
    }

    /**
     * @param value Time interval.
     */
    @JvmName("xkerlpaadvyvfibi")
    public suspend fun timeInterval(`value`: Output<String>) {
        this.timeInterval = value
    }

    /**
     * @param value Win32 error code.
     */
    @JvmName("guuujxqntswwhkrr")
    public suspend fun win32Status(`value`: Output<Int>) {
        this.win32Status = value
    }

    /**
     * @param value Request Count.
     */
    @JvmName("qrnabevugmovitfx")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Request Path
     */
    @JvmName("metujlxryspoutdw")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value HTTP status code.
     */
    @JvmName("nstrjhfswjtlmogh")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Request Sub Status.
     */
    @JvmName("eninqqrpgrvwbbrw")
    public suspend fun subStatus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subStatus = mapped
    }

    /**
     * @param value Time interval.
     */
    @JvmName("cwwgrrktlcytslck")
    public suspend fun timeInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInterval = mapped
    }

    /**
     * @param value Win32 error code.
     */
    @JvmName("axjjpblyesqdcnsr")
    public suspend fun win32Status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.win32Status = mapped
    }

    internal fun build(): StatusCodesBasedTriggerArgs = StatusCodesBasedTriggerArgs(
        count = count,
        path = path,
        status = status,
        subStatus = subStatus,
        timeInterval = timeInterval,
        win32Status = win32Status,
    )
}
