@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.StatusCodesRangeBasedTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trigger based on range of status codes.
 * @property count Request Count.
 * @property path
 * @property statusCodes HTTP status code.
 * @property timeInterval Time interval.
 */
public data class StatusCodesRangeBasedTriggerArgs(
    public val count: Output<Int>? = null,
    public val path: Output<String>? = null,
    public val statusCodes: Output<String>? = null,
    public val timeInterval: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.StatusCodesRangeBasedTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.StatusCodesRangeBasedTriggerArgs =
        com.pulumi.azurenative.web.inputs.StatusCodesRangeBasedTriggerArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .statusCodes(statusCodes?.applyValue({ args0 -> args0 }))
            .timeInterval(timeInterval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatusCodesRangeBasedTriggerArgs].
 */
@PulumiTagMarker
public class StatusCodesRangeBasedTriggerArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var path: Output<String>? = null

    private var statusCodes: Output<String>? = null

    private var timeInterval: Output<String>? = null

    /**
     * @param value Request Count.
     */
    @JvmName("gbqcqjnloniewkkb")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value
     */
    @JvmName("entpfgpeiaejfoub")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value HTTP status code.
     */
    @JvmName("pgjhqdfcqocgeswg")
    public suspend fun statusCodes(`value`: Output<String>) {
        this.statusCodes = value
    }

    /**
     * @param value Time interval.
     */
    @JvmName("tfikmisbvedvjqga")
    public suspend fun timeInterval(`value`: Output<String>) {
        this.timeInterval = value
    }

    /**
     * @param value Request Count.
     */
    @JvmName("faiypooiljbusucb")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptbjliaxguoxvcyd")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value HTTP status code.
     */
    @JvmName("kopfqwlimiwlbalv")
    public suspend fun statusCodes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCodes = mapped
    }

    /**
     * @param value Time interval.
     */
    @JvmName("cdteevcuvxkoxuht")
    public suspend fun timeInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInterval = mapped
    }

    internal fun build(): StatusCodesRangeBasedTriggerArgs = StatusCodesRangeBasedTriggerArgs(
        count = count,
        path = path,
        statusCodes = statusCodes,
        timeInterval = timeInterval,
    )
}
