@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.TwitterRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the app registration for the Twitter provider.
 * @property consumerKey The OAuth 1.0a consumer key of the Twitter application used for sign-in.
 * This setting is required for enabling Twitter Sign-In.
 * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
 * @property consumerSecretSettingName The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
 * application used for sign-in.
 */
public data class TwitterRegistrationArgs(
    public val consumerKey: Output<String>? = null,
    public val consumerSecretSettingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.TwitterRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.TwitterRegistrationArgs =
        com.pulumi.azurenative.web.inputs.TwitterRegistrationArgs.builder()
            .consumerKey(consumerKey?.applyValue({ args0 -> args0 }))
            .consumerSecretSettingName(consumerSecretSettingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TwitterRegistrationArgs].
 */
@PulumiTagMarker
public class TwitterRegistrationArgsBuilder internal constructor() {
    private var consumerKey: Output<String>? = null

    private var consumerSecretSettingName: Output<String>? = null

    /**
     * @param value The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    @JvmName("dfnhhfaearmsngit")
    public suspend fun consumerKey(`value`: Output<String>) {
        this.consumerKey = value
    }

    /**
     * @param value The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
     * application used for sign-in.
     */
    @JvmName("gkflavcbodspwsgw")
    public suspend fun consumerSecretSettingName(`value`: Output<String>) {
        this.consumerSecretSettingName = value
    }

    /**
     * @param value The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    @JvmName("vldcvpwkjidlqule")
    public suspend fun consumerKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerKey = mapped
    }

    /**
     * @param value The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
     * application used for sign-in.
     */
    @JvmName("irbgpbqbyvqbjmdg")
    public suspend fun consumerSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerSecretSettingName = mapped
    }

    internal fun build(): TwitterRegistrationArgs = TwitterRegistrationArgs(
        consumerKey = consumerKey,
        consumerSecretSettingName = consumerSecretSettingName,
    )
}
