@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.VolumeMountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerMountPath Target path on the container where volume is mounted on
 * @property data Config Data to be mounted on the volume
 * @property readOnly Boolean to specify if the mount is read only on the container
 * @property volumeSubPath Sub path in the volume where volume is mounted from.
 */
public data class VolumeMountArgs(
    public val containerMountPath: Output<String>,
    public val `data`: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
    public val volumeSubPath: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.VolumeMountArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.VolumeMountArgs =
        com.pulumi.azurenative.web.inputs.VolumeMountArgs.builder()
            .containerMountPath(containerMountPath.applyValue({ args0 -> args0 }))
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .volumeSubPath(volumeSubPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeMountArgs].
 */
@PulumiTagMarker
public class VolumeMountArgsBuilder internal constructor() {
    private var containerMountPath: Output<String>? = null

    private var `data`: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    private var volumeSubPath: Output<String>? = null

    /**
     * @param value Target path on the container where volume is mounted on
     */
    @JvmName("oirbbrchdqqhwfnj")
    public suspend fun containerMountPath(`value`: Output<String>) {
        this.containerMountPath = value
    }

    /**
     * @param value Config Data to be mounted on the volume
     */
    @JvmName("olptksjpkkkerxxl")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Boolean to specify if the mount is read only on the container
     */
    @JvmName("vaobnbriekunebqq")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value Sub path in the volume where volume is mounted from.
     */
    @JvmName("efiteyhjilppixit")
    public suspend fun volumeSubPath(`value`: Output<String>) {
        this.volumeSubPath = value
    }

    /**
     * @param value Target path on the container where volume is mounted on
     */
    @JvmName("jjhraibysnvcahds")
    public suspend fun containerMountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerMountPath = mapped
    }

    /**
     * @param value Config Data to be mounted on the volume
     */
    @JvmName("djwcruelhyftltxp")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Boolean to specify if the mount is read only on the container
     */
    @JvmName("ybkvurphfksfvadv")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value Sub path in the volume where volume is mounted from.
     */
    @JvmName("kcexuduumwotfeyi")
    public suspend fun volumeSubPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeSubPath = mapped
    }

    internal fun build(): VolumeMountArgs = VolumeMountArgs(
        containerMountPath = containerMountPath ?: throw PulumiNullFieldException("containerMountPath"),
        `data` = `data`,
        readOnly = readOnly,
        volumeSubPath = volumeSubPath ?: throw PulumiNullFieldException("volumeSubPath"),
    )
}
