@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.WsdlService.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The service with name and endpoint names
 * @property endpointQualifiedNames List of the endpoints' qualified names
 * @property qualifiedName The service's qualified name
 */
public data class WsdlService(
    public val endpointQualifiedNames: List<String>? = null,
    public val qualifiedName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.WsdlService> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.WsdlService =
        com.pulumi.azurenative.web.inputs.WsdlService.builder()
            .endpointQualifiedNames(endpointQualifiedNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .qualifiedName(qualifiedName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [WsdlService].
 */
@PulumiTagMarker
public class WsdlServiceBuilder internal constructor() {
    private var endpointQualifiedNames: List<String>? = null

    private var qualifiedName: String? = null

    /**
     * @param value List of the endpoints' qualified names
     */
    @JvmName("ygmagwdcmfixyssj")
    public suspend fun endpointQualifiedNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointQualifiedNames = mapped
    }

    /**
     * @param values List of the endpoints' qualified names
     */
    @JvmName("rlehiiwbatnouidh")
    public suspend fun endpointQualifiedNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointQualifiedNames = mapped
    }

    /**
     * @param value The service's qualified name
     */
    @JvmName("ralfiqgtkxeccpwb")
    public suspend fun qualifiedName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.qualifiedName = mapped
    }

    internal fun build(): WsdlService = WsdlService(
        endpointQualifiedNames = endpointQualifiedNames,
        qualifiedName = qualifiedName ?: throw PulumiNullFieldException("qualifiedName"),
    )
}
