@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property api
 * @property changedTime Timestamp of last connection change
 * @property createdTime Timestamp of the connection creation
 * @property customParameterValues Dictionary of custom parameter values
 * @property displayName Display name
 * @property nonSecretParameterValues Dictionary of nonsecret parameter values
 * @property parameterValues Dictionary of parameter values
 * @property statuses Status of the connection
 * @property testLinks Links to test the API connection
 */
public data class ApiConnectionDefinitionResponseProperties(
    public val api: ApiReferenceResponse? = null,
    public val changedTime: String? = null,
    public val createdTime: String? = null,
    public val customParameterValues: Map<String, String>? = null,
    public val displayName: String? = null,
    public val nonSecretParameterValues: Map<String, String>? = null,
    public val parameterValues: Map<String, String>? = null,
    public val statuses: List<ConnectionStatusDefinitionResponse>? = null,
    public val testLinks: List<ApiConnectionTestLinkResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ApiConnectionDefinitionResponseProperties): ApiConnectionDefinitionResponseProperties = ApiConnectionDefinitionResponseProperties(
            api = javaType.api().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApiReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            changedTime = javaType.changedTime().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime().map({ args0 -> args0 }).orElse(null),
            customParameterValues = javaType.customParameterValues().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            nonSecretParameterValues = javaType.nonSecretParameterValues().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            parameterValues = javaType.parameterValues().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ConnectionStatusDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            testLinks = javaType.testLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApiConnectionTestLinkResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
