@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API connection properties
 * @property method HTTP Method
 * @property requestUri Test link request URI
 */
public data class ApiConnectionTestLinkResponse(
    public val method: String? = null,
    public val requestUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ApiConnectionTestLinkResponse): ApiConnectionTestLinkResponse = ApiConnectionTestLinkResponse(
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            requestUri = javaType.requestUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
