@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * OAuth settings for the API
 * @property options Options available to this parameter
 * @property uiDefinition UI definitions per culture as caller can specify the culture
 * @property value Value of the setting
 */
public data class ApiOAuthSettingsParameterResponse(
    public val options: Any? = null,
    public val uiDefinition: Any? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ApiOAuthSettingsParameterResponse): ApiOAuthSettingsParameterResponse = ApiOAuthSettingsParameterResponse(
            options = javaType.options().map({ args0 -> args0 }).orElse(null),
            uiDefinition = javaType.uiDefinition().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
