@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * OAuth settings for the connection provider
 * @property clientId Resource provider client id
 * @property clientSecret Client Secret needed for OAuth
 * @property customParameters OAuth parameters key is the name of parameter
 * @property identityProvider Identity provider
 * @property properties Read only properties for this oauth setting.
 * @property redirectUrl Url
 * @property scopes OAuth scopes
 */
public data class ApiOAuthSettingsResponse(
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val customParameters: Map<String, ApiOAuthSettingsParameterResponse>? = null,
    public val identityProvider: String? = null,
    public val properties: Any? = null,
    public val redirectUrl: String? = null,
    public val scopes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ApiOAuthSettingsResponse): ApiOAuthSettingsResponse = ApiOAuthSettingsResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            customParameters = javaType.customParameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.ApiOAuthSettingsParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            identityProvider = javaType.identityProvider().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0 }).orElse(null),
            redirectUrl = javaType.redirectUrl().map({ args0 -> args0 }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }),
        )
    }
}
