@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property brandColor Brand color
 * @property description The custom API description
 * @property displayName The display name
 * @property iconUri The icon URI
 * @property id Resource reference id
 * @property name The name of the API
 * @property swagger The JSON representation of the swagger
 * @property type Resource reference type
 */
public data class ApiReferenceResponse(
    public val brandColor: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val iconUri: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val swagger: Any? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ApiReferenceResponse): ApiReferenceResponse = ApiReferenceResponse(
            brandColor = javaType.brandColor().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            iconUri = javaType.iconUri().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            swagger = javaType.swagger().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
