@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API Definitions
 * @property modifiedSwaggerUrl The modified swagger URL
 * @property originalSwaggerUrl The original swagger URL
 */
public data class ApiResourceDefinitionsResponse(
    public val modifiedSwaggerUrl: String? = null,
    public val originalSwaggerUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ApiResourceDefinitionsResponse): ApiResourceDefinitionsResponse = ApiResourceDefinitionsResponse(
            modifiedSwaggerUrl = javaType.modifiedSwaggerUrl().map({ args0 -> args0 }).orElse(null),
            originalSwaggerUrl = javaType.originalSwaggerUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
