@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Suppress

/**
 * Application logs configuration.
 * @property azureBlobStorage Application logs to blob storage configuration.
 * @property azureTableStorage Application logs to azure table storage configuration.
 * @property fileSystem Application logs to file system configuration.
 */
public data class ApplicationLogsConfigResponse(
    public val azureBlobStorage: AzureBlobStorageApplicationLogsConfigResponse? = null,
    public val azureTableStorage: AzureTableStorageApplicationLogsConfigResponse? = null,
    public val fileSystem: FileSystemApplicationLogsConfigResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ApplicationLogsConfigResponse): ApplicationLogsConfigResponse = ApplicationLogsConfigResponse(
            azureBlobStorage = javaType.azureBlobStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AzureBlobStorageApplicationLogsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureTableStorage = javaType.azureTableStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AzureTableStorageApplicationLogsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileSystem = javaType.fileSystem().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.FileSystemApplicationLogsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
