@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property artifactStorageAccessMode
 * @property artifactStorageClassName
 * @property artifactStorageMountPath
 * @property artifactStorageNodeName
 * @property artifactsStorageType
 * @property frontEndServiceConfiguration
 */
public data class ArcConfigurationResponse(
    public val artifactStorageAccessMode: String? = null,
    public val artifactStorageClassName: String? = null,
    public val artifactStorageMountPath: String? = null,
    public val artifactStorageNodeName: String? = null,
    public val artifactsStorageType: String? = null,
    public val frontEndServiceConfiguration: FrontEndConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ArcConfigurationResponse): ArcConfigurationResponse = ArcConfigurationResponse(
            artifactStorageAccessMode = javaType.artifactStorageAccessMode().map({ args0 ->
                args0
            }).orElse(null),
            artifactStorageClassName = javaType.artifactStorageClassName().map({ args0 -> args0 }).orElse(null),
            artifactStorageMountPath = javaType.artifactStorageMountPath().map({ args0 -> args0 }).orElse(null),
            artifactStorageNodeName = javaType.artifactStorageNodeName().map({ args0 -> args0 }).orElse(null),
            artifactsStorageType = javaType.artifactsStorageType().map({ args0 -> args0 }).orElse(null),
            frontEndServiceConfiguration = javaType.frontEndServiceConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.FrontEndConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
