@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Full view of networking configuration for an ASE.
 * @property allowNewPrivateEndpointConnections Property to enable and disable new private endpoint connection creation on ASE
 * @property externalInboundIpAddresses
 * @property ftpEnabled Property to enable and disable FTP on ASEV3
 * @property id Resource Id.
 * @property inboundIpAddressOverride Customer provided Inbound IP Address. Only able to be set on Ase create.
 * @property internalInboundIpAddresses
 * @property kind Kind of resource.
 * @property linuxOutboundIpAddresses
 * @property name Resource Name.
 * @property remoteDebugEnabled Property to enable and disable Remote Debug on ASEV3
 * @property type Resource type.
 * @property windowsOutboundIpAddresses
 */
public data class AseV3NetworkingConfigurationResponse(
    public val allowNewPrivateEndpointConnections: Boolean? = null,
    public val externalInboundIpAddresses: List<String>,
    public val ftpEnabled: Boolean? = null,
    public val id: String,
    public val inboundIpAddressOverride: String? = null,
    public val internalInboundIpAddresses: List<String>,
    public val kind: String? = null,
    public val linuxOutboundIpAddresses: List<String>,
    public val name: String,
    public val remoteDebugEnabled: Boolean? = null,
    public val type: String,
    public val windowsOutboundIpAddresses: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AseV3NetworkingConfigurationResponse): AseV3NetworkingConfigurationResponse = AseV3NetworkingConfigurationResponse(
            allowNewPrivateEndpointConnections = javaType.allowNewPrivateEndpointConnections().map({ args0 ->
                args0
            }).orElse(null),
            externalInboundIpAddresses = javaType.externalInboundIpAddresses().map({ args0 -> args0 }),
            ftpEnabled = javaType.ftpEnabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            inboundIpAddressOverride = javaType.inboundIpAddressOverride().map({ args0 -> args0 }).orElse(null),
            internalInboundIpAddresses = javaType.internalInboundIpAddresses().map({ args0 -> args0 }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            linuxOutboundIpAddresses = javaType.linuxOutboundIpAddresses().map({ args0 -> args0 }),
            name = javaType.name(),
            remoteDebugEnabled = javaType.remoteDebugEnabled().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            windowsOutboundIpAddresses = javaType.windowsOutboundIpAddresses().map({ args0 -> args0 }),
        )
    }
}
