@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Actions which to take by the auto-heal module when a rule is triggered.
 * @property actionType Predefined action to be taken.
 * @property customAction Custom action to be taken.
 * @property minProcessExecutionTime Minimum time the process must execute
 * before taking the action
 */
public data class AutoHealActionsResponse(
    public val actionType: String? = null,
    public val customAction: AutoHealCustomActionResponse? = null,
    public val minProcessExecutionTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AutoHealActionsResponse): AutoHealActionsResponse = AutoHealActionsResponse(
            actionType = javaType.actionType().map({ args0 -> args0 }).orElse(null),
            customAction = javaType.customAction().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AutoHealCustomActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            minProcessExecutionTime = javaType.minProcessExecutionTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
