@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Suppress

/**
 * Rules that can be defined for auto-heal.
 * @property actions Actions to be executed when a rule is triggered.
 * @property triggers Conditions that describe when to execute the auto-heal actions.
 */
public data class AutoHealRulesResponse(
    public val actions: AutoHealActionsResponse? = null,
    public val triggers: AutoHealTriggersResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AutoHealRulesResponse): AutoHealRulesResponse = AutoHealRulesResponse(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AutoHealActionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            triggers = javaType.triggers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AutoHealTriggersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
