@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Triggers for auto-heal.
 * @property privateBytesInKB A rule based on private bytes.
 * @property requests A rule based on total requests.
 * @property slowRequests A rule based on request execution time.
 * @property slowRequestsWithPath A rule based on multiple Slow Requests Rule with path
 * @property statusCodes A rule based on status codes.
 * @property statusCodesRange A rule based on status codes ranges.
 */
public data class AutoHealTriggersResponse(
    public val privateBytesInKB: Int? = null,
    public val requests: RequestsBasedTriggerResponse? = null,
    public val slowRequests: SlowRequestsBasedTriggerResponse? = null,
    public val slowRequestsWithPath: List<SlowRequestsBasedTriggerResponse>? = null,
    public val statusCodes: List<StatusCodesBasedTriggerResponse>? = null,
    public val statusCodesRange: List<StatusCodesRangeBasedTriggerResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AutoHealTriggersResponse): AutoHealTriggersResponse = AutoHealTriggersResponse(
            privateBytesInKB = javaType.privateBytesInKB().map({ args0 -> args0 }).orElse(null),
            requests = javaType.requests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.RequestsBasedTriggerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            slowRequests = javaType.slowRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.SlowRequestsBasedTriggerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            slowRequestsWithPath = javaType.slowRequestsWithPath().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.SlowRequestsBasedTriggerResponse.Companion.toKotlin(args0)
                })
            }),
            statusCodes = javaType.statusCodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StatusCodesBasedTriggerResponse.Companion.toKotlin(args0)
                })
            }),
            statusCodesRange = javaType.statusCodesRange().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StatusCodesRangeBasedTriggerResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
