@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the Azure Active Directory login flow.
 * @property disableWWWAuthenticate <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
 * @property loginParameters Login parameters to send to the OpenID Connect authorization endpoint when
 * a user logs in. Each parameter must be in the form "key=value".
 */
public data class AzureActiveDirectoryLoginResponse(
    public val disableWWWAuthenticate: Boolean? = null,
    public val loginParameters: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AzureActiveDirectoryLoginResponse): AzureActiveDirectoryLoginResponse = AzureActiveDirectoryLoginResponse(
            disableWWWAuthenticate = javaType.disableWWWAuthenticate().map({ args0 -> args0 }).orElse(null),
            loginParameters = javaType.loginParameters().map({ args0 -> args0 }),
        )
    }
}
