@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Http logs to azure blob storage configuration.
 * @property enabled True if configuration is enabled, false if it is disabled and null if configuration is not set.
 * @property retentionInDays Retention in days.
 * Remove blobs older than X days.
 * 0 or lower means no retention.
 * @property sasUrl SAS url to a azure blob container with read/write/list/delete permissions.
 */
public data class AzureBlobStorageHttpLogsConfigResponse(
    public val enabled: Boolean? = null,
    public val retentionInDays: Int? = null,
    public val sasUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AzureBlobStorageHttpLogsConfigResponse): AzureBlobStorageHttpLogsConfigResponse = AzureBlobStorageHttpLogsConfigResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            retentionInDays = javaType.retentionInDays().map({ args0 -> args0 }).orElse(null),
            sasUrl = javaType.sasUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
