@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the Azure Static Web Apps provider.
 * @property enabled <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property registration The configuration settings of the Azure Static Web Apps registration.
 */
public data class AzureStaticWebAppsResponse(
    public val enabled: Boolean? = null,
    public val registration: AzureStaticWebAppsRegistrationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AzureStaticWebAppsResponse): AzureStaticWebAppsResponse = AzureStaticWebAppsResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            registration = javaType.registration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AzureStaticWebAppsRegistrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
