@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Application logs to Azure table storage configuration.
 * @property level Log level.
 * @property sasUrl SAS URL to an Azure table with add/query/delete permissions.
 */
public data class AzureTableStorageApplicationLogsConfigResponse(
    public val level: String? = null,
    public val sasUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AzureTableStorageApplicationLogsConfigResponse): AzureTableStorageApplicationLogsConfigResponse =
            AzureTableStorageApplicationLogsConfigResponse(
                level = javaType.level().map({ args0 -> args0 }).orElse(null),
                sasUrl = javaType.sasUrl(),
            )
    }
}
