@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
 * @property frequencyInterval How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
 * @property frequencyUnit The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
 * @property keepAtLeastOneBackup True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
 * @property lastExecutionTime Last time when this schedule was triggered.
 * @property retentionPeriodInDays After how many days backups should be deleted.
 * @property startTime When the schedule should start working.
 */
public data class BackupScheduleResponse(
    public val frequencyInterval: Int,
    public val frequencyUnit: String,
    public val keepAtLeastOneBackup: Boolean,
    public val lastExecutionTime: String,
    public val retentionPeriodInDays: Int,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.BackupScheduleResponse): BackupScheduleResponse = BackupScheduleResponse(
            frequencyInterval = javaType.frequencyInterval(),
            frequencyUnit = javaType.frequencyUnit(),
            keepAtLeastOneBackup = javaType.keepAtLeastOneBackup(),
            lastExecutionTime = javaType.lastExecutionTime(),
            retentionPeriodInDays = javaType.retentionPeriodInDays(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
