@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the capabilities/features allowed for a specific SKU.
 * @property name Name of the SKU capability.
 * @property reason Reason of the SKU capability.
 * @property value Value of the SKU capability.
 */
public data class CapabilityResponse(
    public val name: String? = null,
    public val reason: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.CapabilityResponse): CapabilityResponse = CapabilityResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            reason = javaType.reason().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
