@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Connection error
 * @property code Code of the status
 * @property etag Resource ETag
 * @property id Resource id
 * @property location Resource location
 * @property message Description of the status
 * @property name Resource name
 * @property tags Resource tags
 * @property type Resource type
 */
public data class ConnectionErrorResponse(
    public val code: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val message: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConnectionErrorResponse): ConnectionErrorResponse = ConnectionErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
