@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backendUri The URI of the backend
 * @property connectionGatewayInstallation The gateway installation reference
 * @property contactInformation The gateway admin
 * @property description The gateway description
 * @property displayName The gateway display name
 * @property machineName The machine name of the gateway
 * @property status The gateway status
 */
public data class ConnectionGatewayDefinitionResponseProperties(
    public val backendUri: String? = null,
    public val connectionGatewayInstallation: ConnectionGatewayReferenceResponse? = null,
    public val contactInformation: List<String>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val machineName: String? = null,
    public val status: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConnectionGatewayDefinitionResponseProperties): ConnectionGatewayDefinitionResponseProperties =
            ConnectionGatewayDefinitionResponseProperties(
                backendUri = javaType.backendUri().map({ args0 -> args0 }).orElse(null),
                connectionGatewayInstallation = javaType.connectionGatewayInstallation().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.ConnectionGatewayReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                contactInformation = javaType.contactInformation().map({ args0 -> args0 }),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                machineName = javaType.machineName().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
